--
-- paginateResults.sql
--
DECLARE
  v_queryCtx DBMS_XMLquery.ctxType;
  v_result   CLOB;
BEGIN
  -- set up the query context
  v_queryCtx := DBMS_XMLQuery.newContext('SELECT * FROM employees');
 
  DBMS_XMLQuery.setSkipRows(v_queryCtx,3); -- set the number of rows to skip
  DBMS_XMLQuery.setMaxRows(v_queryCtx,10); -- set the max number of rows per fetch
 
  v_result := DBMS_XMLQuery.getXML(v_queryCtx); -- get the first result
 
  printClobOut(v_result); -- print the result
  DBMS_XMLQuery.setSkipRows(v_queryCtx,0); -- from now don't skip any more rows

  DBMS_XMLQuery.setRaiseNoRowsException(v_queryCtx,true);
                                         -- raise no rows exception
  BEGIN
    LOOP  -- loop forever
      v_result := DBMS_XMLQuery.getXML(v_queryCtx); -- get the next batch 
      printClobOut(v_result);             -- print the next batch of 10 rows
    END LOOP;
  EXCEPTION
    WHEN OTHERS THEN
    -- DBMS_OUTPUT.PUT_LINE(sqlerrm);
       NULL; -- termination condition, nothing to do
  END;
  DBMS_XMLQuery.closeContext(v_queryCtx);  -- close the handle
END;
/
